<?php if( $this->ion_auth->is_admin() ) : ?>
<div class="row">
    <?php foreach($info_box as $info) : ?>
    <div class="col-lg-3 col-xs-6">
        <div class="small-box bg-<?=$info->box?>">
        <div class="inner">
            <h3><?=$info->total;?></h3>
            <p><?=$info->title;?></p>
        </div>
        <div class="icon">
            <i class="fa fa-<?=$info->icon?>"></i>
        </div>
        <a href="<?=base_url().strtolower($info->title);?>" class="small-box-footer">
            More info <i class="fa fa-arrow-circle-right"></i>
        </a>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<?php elseif( $this->ion_auth->in_group('dosen') ) : ?>

<div class="row">
    <div class="col-sm-4">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">Informasi Akun</h3>
            </div>
            <table class="table table-hover">
                <tr>
                    <th>Nama</th>
                    <td><?=$dosen->nama_dosen?></td>
                </tr>
                <tr>
                    <th>NIP</th>
                    <td><?=$dosen->nip?></td>
                </tr>
                <tr>
                    <th>Email</th>
                    <td><?=$dosen->email?></td>
                </tr>
                <tr>
                    <th>Jenis Ujian</th>
                    <td><?=$dosen->nama_matkul?></td>
                </tr>
                <tr>
                    <th>Daftar Kelas</th>
                    <td>
                        <ol class="pl-4">
                        <?php foreach ($kelas as $k) : ?>
                            <li><?=$k->nama_kelas?></li>
                        <?php endforeach;?>
                        </ol>
                    </td>
                </tr>
            </table>
        </div>
    </div>
    <div class="col-sm-8">
        <div class="box box-solid">
            <div class="box-header bg-purple">
                <h3 class="box-title">Pemberitahuan</h3>
            </div>
            <div class="box-body">
                <p>Jadwal Ujian</p>
                <ul class="pl-4">
                    <li>Periode daftar dari tanggal 03 Juli s.d 30 Agustus 2021</li>
                    <li>Tes Tulis : 02 Sept 2021 dan Wawancara : 03 Sept 2021 (Khusus bagi yang mengambil Jalur Masuk KIP dan Fakultas FKIP)</li>
                    <li>Pengumuman : 04 Sept 2021</li>
                    <br>
                    <li>Pengumuman akan di umumkan pada melalui website Universitas Serambi Mekkah</li>
                    <li>website : https://serambimekkah.ac.id/</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php else : ?>

<div class="row">
    <div class="col-sm-4">
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">Informasi Akun</h3>
            </div>
            <table class="table table-hover">
                <tr>
                    <th>Kode Akun</th>
                    <td><?=$mahasiswa->nim?></td>
                </tr>
                <tr>
                    <th>Nama</th>
                    <td><?=$mahasiswa->nama?></td>
                </tr>

                <tr>
                    <th>Email</th>
                    <td><?=$mahasiswa->email?></td>
                </tr>
                <tr>
                    <th>Fakultas</th>
                    <td><?=$mahasiswa->nama_jurusan?></td>
                </tr>
                <tr>
                    <th>Kelas</th>
                    <td><?=$mahasiswa->nama_kelas?></td>
                </tr>
            </table>
        </div>
    </div>
    <div class="col-sm-8">
        <div class="box box-solid">
            <div class="box-header bg-purple">
                <h3 class="box-title">Pemberitahuan</h3>
            </div>
            <div class="box-body">
                <p>PETUNJUK UMUM</p>
                <ul class="pl-4">
                    <li>Pastikan Nama Peserta sesuai dengan identitas </li>
                    <li>Pilih salah satu alternatif jawaban (A,B,C,D atau E) yang dianggap paling benar</li>
                    <li>Tersedia waktu 120 menit untuk mengerjakan paket soal tersebut</li>
                    <li>Jumlah soal sebanyak 100 soal, pada settiap butir soal terdapat 5 (lima) pilihan jawaban</li>
                    <li>Periksa dan bacalah soal-soal sebelum anda menjawabnya</li>
                    <li>Tidak diizinkan menggunakan kalkuator, HP, tabel matematika atau alat bantu hitung lainnya</li>
                    <li>Boleh mengerjakan soal yang di anggap mudah terlebih dahulu </li>
                    <li>Periksalah pekerjaan Anda sebelum tekan "SELESAI"</li>
                    <h6><strong><span style="color: #0000ff;">Note :</span></strong></h6>
<h6><span style="color: #0000ff;"><em>Jika ada permasalahan saat ujian, bisa hubungi 085260377004.</em></span></h6>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php endif; ?>