<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Mahasiswa extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		if (!$this->ion_auth->logged_in()) {
			redirect('auth');
		} else if (!$this->ion_auth->is_admin()) {
			show_error('Hanya Administrator yang diberi hak untuk mengakses halaman ini, <a href="' . base_url('dashboard') . '">Kembali ke menu awal</a>', 403, 'Akses Terlarang');
		}
		$this->load->library(['datatables', 'form_validation']); // Load Library Ignited-Datatables
		$this->load->model('Master_model', 'master');
		$this->form_validation->set_error_delimiters('', '');
	}

	public function output_json($data, $encode = true)
	{
		if ($encode) $data = json_encode($data);
		$this->output->set_content_type('application/json')->set_output($data);
	}

	public function index()
	{
		$data = [
			'user' => $this->ion_auth->user()->row(),
			'judul'	=> 'Mahasiswa',
			'subjudul' => 'Data Mahasiswa'
		];
		$this->load->view('_templates/dashboard/_header.php', $data);
		$this->load->view('master/mahasiswa/data');
		$this->load->view('_templates/dashboard/_footer.php');
	}

	public function data()
	{
		$this->output_json($this->master->getDataMahasiswa(), false);
	}

	public function add()
	{
		$data = [
			'user' => $this->ion_auth->user()->row(),
			'judul'	=> 'Mahasiswa',
			'subjudul' => 'Tambah Data Mahasiswa'
		];
		$this->load->view('_templates/dashboard/_header.php', $data);
		$this->load->view('master/mahasiswa/add');
		$this->load->view('_templates/dashboard/_footer.php');
	}

	public function edit($id)
	{
		$mhs = $this->master->getMahasiswaById($id);
		$data = [
			'user' 		=> $this->ion_auth->user()->row(),
			'judul'		=> 'Mahasiswa',
			'subjudul'	=> 'Edit Data Mahasiswa',
			'jurusan'	=> $this->master->getJurusan(),
			'kelas'		=> $this->master->getKelasByJurusan($mhs->jurusan_id),
			'mahasiswa' => $mhs
		];
		$this->load->view('_templates/dashboard/_header.php', $data);
		$this->load->view('master/mahasiswa/edit');
		$this->load->view('_templates/dashboard/_footer.php');
	}

	public function validasi_mahasiswa($method)
	{
		$id_mahasiswa 	= $this->input->post('id_mahasiswa', true);
		$nim 			= $this->input->post('nim', true);
		$email 			= $this->input->post('email', true);
		if ($method == 'add') {
			$u_nim = '|is_unique[mahasiswa.nim]';
			$u_email = '|is_unique[mahasiswa.email]';
		} else {
			$dbdata 	= $this->master->getMahasiswaById($id_mahasiswa);
			$u_nim		= $dbdata->nim === $nim ? "" : "|is_unique[mahasiswa.nim]";
			$u_email	= $dbdata->email === $email ? "" : "|is_unique[mahasiswa.email]";
		}
		$this->form_validation->set_rules('nim', 'NIM', 'required|numeric|trim|min_length[8]|max_length[12]' . $u_nim);
		$this->form_validation->set_rules('nama', 'Nama', 'required|trim|min_length[3]|max_length[50]');
		$this->form_validation->set_rules('email', 'Email', 'required|trim|valid_email' . $u_email);
		$this->form_validation->set_rules('jenis_kelamin', 'Jenis Kelamin', 'required');
		$this->form_validation->set_rules('jurusan', 'Jurusan', 'required');
		$this->form_validation->set_rules('kelas', 'Kelas', 'required');

		$this->form_validation->set_message('required', 'Kolom {field} wajib diisi');
	}

	public function save()
	{
		$method = $this->input->post('method', true);
		$this->validasi_mahasiswa($method);

		if ($this->form_validation->run() == FALSE) {
			$data = [
				'status'	=> false,
				'errors'	=> [
					'nim' => form_error('nim'),
					'nama' => form_error('nama'),
					'email' => form_error('email'),
					'jenis_kelamin' => form_error('jenis_kelamin'),
					'jurusan' => form_error('jurusan'),
					'kelas' => form_error('kelas'),
				]
			];
			$this->output_json($data);
		} else {
			$input = [
				'nim' 			=> $this->input->post('nim', true),
				'email' 		=> $this->input->post('email', true),
				'nama' 			=> $this->input->post('nama', true),
				'jenis_kelamin' => $this->input->post('jenis_kelamin', true),
				'kelas_id' 		=> $this->input->post('kelas', true),
				'program_study' => $this->input->post('program_study', true),
				'jalur_masuk'   => $this->input->post('jalur_masuk', true),
			];
			if ($method === 'add') {
				$action = $this->master->create('mahasiswa', $input);
			} else if ($method === 'edit') {
				$id = $this->input->post('id_mahasiswa', true);
				$action = $this->master->update('mahasiswa', $input, 'id_mahasiswa', $id);
			}

			if ($action) {
				$this->output_json(['status' => true]);
			} else {
				$this->output_json(['status' => false]);
			}
		}
	}

	public function delete()
	{
		$chk = $this->input->post('checked', true);
		if (!$chk) {
			$this->output_json(['status' => false]);
		} else {
			if ($this->master->delete('mahasiswa', $chk, 'id_mahasiswa')) {
				$this->output_json(['status' => true, 'total' => count($chk)]);
			}
		}
	}

	public function create_user()
	{
		$id = $this->input->get('id', true);
		$data = $this->master->getMahasiswaById($id);
		$nama = explode(' ', $data->nama);
		$first_name = $nama[0];
		$last_name = end($nama);

		$username = $data->nim;
		$password = $data->nim;
		$email = $data->email;
		$additional_data = [
			'first_name'	=> $first_name,
			'last_name'		=> $last_name
		];
		$group = array('3'); // Sets user to dosen.

		if ($this->ion_auth->username_check($username)) {
			$data = [
				'status' => false,
				'msg'	 => 'Username tidak tersedia (sudah digunakan).'
			];
		} else if ($this->ion_auth->email_check($email)) {
			$data = [
				'status' => false,
				'msg'	 => 'Email tidak tersedia (sudah digunakan).'
			];
		} else {
			$this->ion_auth->register($username, $password, $email, $additional_data, $group);
			$data = [
				'status'	=> true,
				'msg'	 => 'User berhasil dibuat. NISN digunakan sebagai password pada saat login.'
			];
		}
		$this->output_json($data);
	}

	public function import($import_data = null)
	{
		$data = [
			'user' => $this->ion_auth->user()->row(),
			'judul'	=> 'Mahasiswa',
			'subjudul' => 'Import Data Mahasiswa',
			'kelas' => $this->master->getAllKelas()
		];
		if ($import_data != null) $data['import'] = $import_data;

		$this->load->view('_templates/dashboard/_header', $data);
		$this->load->view('master/mahasiswa/import');
		$this->load->view('_templates/dashboard/_footer');
	}
	public function preview()
	{
		$config['upload_path']		= './uploads/import/';
		$config['allowed_types']	= 'xls|xlsx|csv';
		$config['max_size']			= 2048;
		$config['encrypt_name']		= true;

		$this->load->library('upload', $config);

		if (!$this->upload->do_upload('upload_file')) {
			$error = $this->upload->display_errors();
			echo $error;
			die;
		} else {
			$file = $this->upload->data('full_path');
			$ext = $this->upload->data('file_ext');

			switch ($ext) {
				case '.xlsx':
					$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
					break;
				case '.xls':
					$reader = new \PhpOffice\PhpSpreadsheet\Reader\Xls();
					break;
				case '.csv':
					$reader = new \PhpOffice\PhpSpreadsheet\Reader\Csv();
					break;
				default:
					echo "unknown file ext";
					die;
			}

			$spreadsheet = $reader->load($file);
			$sheetData = $spreadsheet->getActiveSheet()->toArray();
			$data = [];
			for ($i = 1; $i < count($sheetData); $i++) {
				$data[] = [
					'nim' => $sheetData[$i][0],
					'nama' => $sheetData[$i][1],
					'email' => $sheetData[$i][2],
					'no_hp' => $sheetData[$i][3],
					'jenis_kelamin' => $sheetData[$i][4],
					'kelas_id' => $sheetData[$i][5],
					'program_study' => $sheetData[$i][6],
					'jalur_masuk' => $sheetData[$i][7]
				];
			}

			unlink($file);

			$this->import($data);
		}
	}

	public function do_import()
	{
		$input = json_decode($this->input->post('data', true));
		$data = [];
		foreach ($input as $d) {
			$data = [
				'nim' => $d->nim,
				'nama' => $d->nama,
				'email' => $d->email,
				'no_hp' => $d->no_hp,
				'jenis_kelamin' => $d->jenis_kelamin,
				'kelas_id' => $d->kelas_id,
				'program_study' => $d->program_study,
				'jalur_masuk' => $d->jalur_masuk
			];
			
			
			$cek = $this->db->get_where('mahasiswa', ['nim' => $data['nim']])->row_array();

			if (!$cek) {
				$this->db->insert('mahasiswa', $data);
			} else {
				$data_update = [
					'nama'          => $data['nama'],
					'no_hp'         => $data['no_hp'],
					'jenis_kelamin' => $data['jenis_kelamin'],
					// 'kelas_id'      => $data['kelas_id'],
					'program_study' => $data['program_study'],
					'jalur_masuk'   => $data['jalur_masuk']
				];
				$this->db->where('nim', $data['nim']);
				$this->db->update('mahasiswa', $data_update);
			}
		}
		
		redirect('mahasiswa');

// 		$save = $this->master->create('mahasiswa', $data, true);
// 		if ($save) {
// 			redirect('mahasiswa');
// 		} else {
// 			redirect('mahasiswa/import');
// 		}
	}
	
	public function export_excel()
	{
		$dataMhs = $this->master->getAllMahasiswa();

		// echo "<pre/>";
		// var_dump($dataMhs);
		// die;

		$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet;

		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue('A1', 'No')
			->setCellValue('B1', 'Nama')
			->setCellValue('C1', 'NPM')
			->setCellValue('D1', 'Email')
			->setCellValue('E1', 'No HP')
			->setCellValue('F1', 'Kelas')
			->setCellValue('G1', 'Jurusan')
			->setCellValue('H1', 'Program Study')
			->setCellValue('I1', 'Jalur Masuk');

		$i = 2;
		$no = 1;

		foreach ($dataMhs as $mhs) {
			$spreadsheet->setActiveSheetIndex(0)
				->setCellValue('A' . $i, $no)
				->setCellValue('B' . $i, $mhs->nama)
				->setCellValueExplicit('C' . $i, $mhs->nim, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING)
				->setCellValue('D' . $i, $mhs->email)
				->setCellValueExplicit('E' . $i, $mhs->no_hp, \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING)
				->setCellValue('F' . $i, $mhs->nama_kelas)
				->setCellValue('G' . $i, $mhs->nama_jurusan)
				->setCellValue('H' . $i, $mhs->program_study)
				->setCellValue('I' . $i, $mhs->jalur_masuk);
			$i++;
			$no++;
		}

		$spreadsheet->getActiveSheet()->setTitle('Data Mahasiswa Ujian CBT-USM');
		$spreadsheet->setActiveSheetIndex(0);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Data Mahasiswa Ujian CBT-USM.xlsx"');
		header('Cache-Control: max-age=0');


		// // If you're serving to IE 9, then the following may be needed
		// header('Cache-Control: max-age=1');

		// // If you're serving to IE over SSL, then the following may be needed
		// header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		// header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		// header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		// header('Pragma: public'); // HTTP/1.0


		$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
		$writer->save('php://output');
		exit;
	}
}
