<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class HasilUjian extends CI_Controller {

	public function __construct(){
		parent::__construct();
		if (!$this->ion_auth->logged_in()){
			redirect('auth');
		}
		
		$this->load->library(['datatables']);// Load Library Ignited-Datatables
		$this->load->model('Master_model', 'master');
		$this->load->model('Ujian_model', 'ujian');
		
		$this->user = $this->ion_auth->user()->row();
	}

	public function output_json($data, $encode = true)
	{
		if($encode) $data = json_encode($data);
		$this->output->set_content_type('application/json')->set_output($data);
	}

	public function data()
	{
		$nip_dosen = null;
		
		if( $this->ion_auth->in_group('dosen') ) {
			$nip_dosen = $this->user->username;
		}

		$this->output_json($this->ujian->getHasilUjian($nip_dosen), false);
	}

	public function NilaiMhs($id)
	{
		$this->output_json($this->ujian->HslUjianById($id, true), false);
	}

	public function index()
	{
		$data = [
			'user' => $this->user,
			'judul'	=> 'Ujian',
			'subjudul'=> 'Hasil Ujian',
		];
		$this->load->view('_templates/dashboard/_header.php', $data);
		$this->load->view('ujian/hasil');
		$this->load->view('_templates/dashboard/_footer.php');
	}
	
	public function detail($id)
	{
		$ujian = $this->ujian->getUjianById($id);
		$nilai = $this->ujian->bandingNilai($id);

		$data = [
			'user' => $this->user,
			'judul'	=> 'Ujian',
			'subjudul'=> 'Detail Hasil Ujian',
			'ujian'	=> $ujian,
			'nilai'	=> $nilai
		];

		$this->load->view('_templates/dashboard/_header.php', $data);
		$this->load->view('ujian/detail_hasil');
		$this->load->view('_templates/dashboard/_footer.php');
	}

	public function cetak($id)
	{
		$this->load->library('Pdf');

		$mhs 	= $this->ujian->getIdMahasiswa($this->user->username);
		$hasil 	= $this->ujian->HslUjian($id, $mhs->id_mahasiswa)->row();
		$ujian 	= $this->ujian->getUjianById($id);
		
		$data = [
			'ujian' => $ujian,
			'hasil' => $hasil,
			'mhs'	=> $mhs
		];
		
		$this->load->view('ujian/cetak', $data);
	}

	public function cetak_detail($id)
	{
		$this->load->library('Pdf');

		$ujian = $this->ujian->getUjianById($id);
		$nilai = $this->ujian->bandingNilai($id);
		$hasil = $this->ujian->HslUjianById($id)->result();

		$data = [
			'ujian'	=> $ujian,
			'nilai'	=> $nilai,
			'hasil'	=> $hasil
		];

		$this->load->view('ujian/cetak_detail', $data);
	}
	
	public function cetak_detail_excel($id)
	{
		$ujian = $this->ujian->getUjianById($id);
		$nilai = $this->ujian->bandingNilai($id);
		$hasil = $this->ujian->HslUjianById($id)->result();

		// echo json_encode($hasil);
		// exit;

		$spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet;

		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue('A1', 'A. Rangkuman Detail Hasil Ujian');

		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue('A2', 'Nama Ujian')
			->setCellValue('B2', 'Mata Kuliah')
			->setCellValue('C2', 'Jumlah Soal')
			->setCellValue('D2', 'Dosen')
			->setCellValue('E2', 'Waktu')
			->setCellValue('F2', 'Nilai Terendah')
			->setCellValue('G2', 'Tanggal Mulai')
			->setCellValue('H2', 'Nilai Tertinggi')
			->setCellValue('I2', 'Tanggal Selesai')
			->setCellValue('J2', 'Rata-rata Nilai');

		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue('A3', $ujian->nama_ujian)
			->setCellValue('B3', $ujian->nama_matkul)
			->setCellValue('C3', $ujian->jumlah_soal)
			->setCellValue('D3', $ujian->nama_dosen)
			->setCellValue('E3', $ujian->waktu . ' Menit')
			->setCellValue('F3', $nilai->min_nilai)
			->setCellValue('G3', strftime('%A, %d %B %Y', strtotime($ujian->tgl_mulai)))
			->setCellValue('H3', $nilai->max_nilai)
			->setCellValue('I3', strftime('%A, %d %B %Y', strtotime($ujian->terlambat)))
			->setCellValue('J3', $nilai->avg_nilai);

		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue('A5', 'B. Detail Hasil Ujian');

		$spreadsheet->setActiveSheetIndex(0)
			->setCellValue('A7', 'No')
			->setCellValue('B7', 'Nama')
			->setCellValue('C7', 'No HP')
			->setCellValue('D7', 'Kelas')
			->setCellValue('E7', 'Jurusan')
			->setCellValue('F7', 'Program Study')
			->setCellValue('G7', 'Jalur Masuk')
			->setCellValue('H7', 'Jumlah Benar')
			->setCellValue('I7', 'Nila');

		$i = 8;
		$no = 1;
		foreach ($hasil as $data) {
			$spreadsheet->setActiveSheetIndex(0)
				->setCellValue('A' . $i, $no)
				->setCellValue('B' . $i, $data->nama)
				->setCellValue('C' . $i, $data->no_hp)
				->setCellValue('D' . $i, $data->nama_kelas)
				->setCellValue('E' . $i, $data->nama_jurusan)
				->setCellValue('F' . $i, $data->program_study)
				->setCellValue('G' . $i, $data->jalur_masuk)
				->setCellValue('H' . $i, $data->jml_benar)
				->setCellValue('I' . $i, $data->nilai);
			$i++;
			$no++;
		}



		$spreadsheet->getActiveSheet()->setTitle('Hasil Ujian' . date('d-m-Y H'));
		$spreadsheet->setActiveSheetIndex(0);

		header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
		header('Content-Disposition: attachment;filename="Hasil Ujian CBT-USM.xlsx"');
		header('Cache-Control: max-age=0');


		// // If you're serving to IE 9, then the following may be needed
		// header('Cache-Control: max-age=1');

		// // If you're serving to IE over SSL, then the following may be needed
		// header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
		// header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
		// header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
		// header('Pragma: public'); // HTTP/1.0


		$writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx');
		$writer->save('php://output');
		exit;
	}
	
}